;UDF Manager



Func _ISN_Toggle_UDF_Manager()
	$ISN_UDFManager_WinState = WinGetState($ISN_UDF_Manager_GUI, "")
	If BitAND($ISN_UDFManager_WinState, 2) Then
		_ISN_Hide_UDF_Manager()
	Else
		_ISN_Show_UDF_Manager()
	EndIf
EndFunc   ;==>_ISN_Toggle_UDF_Manager

Func _ISN_Show_UDF_Manager()
	Local $Filter = ""

	;Create TreeView
	$ISN_UDF_Manager_FileTree_Dummy_PosArray = _ControlGetPos($ISN_UDF_Manager_GUI, "", $ISN_UDF_Manager_FileTree_Dummy)
	If IsArray($ISN_UDF_Manager_FileTree_Dummy_PosArray) And $ISN_UDF_Manager_GUI_Treeview = "" Then
		GUISwitch($ISN_UDF_Manager_GUI)
		$ISN_UDF_Manager_GUI_Treeview = _GUICtrlTVExplorer_Create(_ISN_Variablen_aufloesen($UDFs_Folder), $ISN_UDF_Manager_FileTree_Dummy_PosArray[0], $ISN_UDF_Manager_FileTree_Dummy_PosArray[1], $ISN_UDF_Manager_FileTree_Dummy_PosArray[2], $ISN_UDF_Manager_FileTree_Dummy_PosArray[3], BitOR($TVS_HASBUTTONS, $TVS_HASLINES, $TVS_LINESATROOT, $TVS_SHOWSELALWAYS), $WS_EX_CLIENTEDGE, $TV_FLAG_SHOWFILESEXTENSION + $TV_FLAG_SHOWFILES + $TV_FLAG_SHOWFOLDERICON + $TV_FLAG_SHOWFILEICON + $TV_FLAG_SHOWLIKEEXPLORER, "_Projecttree_event", $Filter, "", 0)
		GUICtrlSetResizing($ISN_UDF_Manager_GUI_Treeview, 354)
		$ISN_UDF_Manager_GUI_hTreeview = GUICtrlGetHandle($ISN_UDF_Manager_GUI_Treeview)
		GUICtrlSetFont($ISN_UDF_Manager_GUI_hTreeview, $treefont_size, 400, 0, $treefont_font) ;Schrift
		GUICtrlSetColor($ISN_UDF_Manager_GUI_hTreeview, $treefont_colour) ;Farbe
		GUICtrlSetState($ISN_UDF_Manager_GUI_Treeview, $GUI_DROPACCEPTED)
		If $Tools_UDFManager_ShowAutoItIncludes = "true" Then _TV_AddVirtualDrive(_TV_Index($ISN_UDF_Manager_GUI_Treeview), _ISN_Variablen_aufloesen($PathToAutoItIncludes), _Get_langstr(1074))
		_GUICtrlTVExplorer_Expand($ISN_UDF_Manager_GUI_hTreeview)
	EndIf
	If $ISN_UDF_Manager_FilePath_Label <> "" And FileExists(GUICtrlRead($ISN_UDF_Manager_FilePath_Label)) Then
		_ISN_UDF_Manager_Inspect_UDF(GUICtrlRead($ISN_UDF_Manager_FilePath_Label))
	Else
		_ISN_UDF_Manager_Inspect_UDF("")
	EndIf
	_ISN_UDF_Manager_TabSelectEvent()

	If $Zusaetzliche_Include_Pfade_ueber_ISN_verwalten <> "true" Then
		$Result = _Show_Warning("UDFsNotManagedByISN", 513, _Get_langstr(394), _Get_langstr(1425) & " " & _Get_langstr(1426), _Get_langstr(429), _Get_langstr(430))
		If $Result = 1 Then
			$Zusaetzliche_Include_Pfade_ueber_ISN_verwalten = "true"
			If _Config_Read("manage_additional_includes_with_ISN", "false") <> $Zusaetzliche_Include_Pfade_ueber_ISN_verwalten Then _ISN_Settings_CheckExistingIncludePathsInRegistry()
			_Write_in_Config("manage_additional_includes_with_ISN", "true")
			_Pfade_fuer_Weitere_Includes_in_Registrierung_uebernehmen()
		EndIf
	EndIf
	_ISN_UDFManager_SetWarningLabel()
	GUISetState(@SW_SHOW, $ISN_UDF_Manager_GUI)
	_GUICtrlTab_ActivateTab($ISN_UDF_Manager_Tab, 0)
	AdlibRegister("_ISN_UDFManager_BackgroundScanForAcInput", 1)


EndFunc   ;==>_ISN_Show_UDF_Manager

Func _ISN_UDFManager_SetWarningLabel()
	If $Zusaetzliche_Include_Pfade_ueber_ISN_verwalten = "true" Then
		GUICtrlSetData($ISN_UDF_Manager_Bottom_Label, _Get_langstr(1427))
		GUICtrlSetColor($ISN_UDF_Manager_Bottom_Label, 0x808080)
	Else
		GUICtrlSetData($ISN_UDF_Manager_Bottom_Label, _Get_langstr(1425))
		GUICtrlSetColor($ISN_UDF_Manager_Bottom_Label, 0xFF0000)
	EndIf
EndFunc   ;==>_ISN_UDFManager_SetWarningLabel

Func _ISN_UDFManager_ClearSearchbar()
	GUICtrlSetData($ISN_UDF_Manager_FileSearch_Input, "")
	_WinAPI_SetFocus(GUICtrlGetHandle($ISN_UDF_Manager_FileSearch_Input))
EndFunc   ;==>_ISN_UDFManager_ClearSearchbar


Func _ISN_UDFManager_AcInputSelectItem()
	_AcInputUDF_AutocompleteSelectedItem()
	_ISN_UDF_Manager_Inspect_UDF(GUICtrlRead($ISN_UDF_Manager_FileSearch_Input))
	_GUICtrlTVExplorer_Expand($ISN_UDF_Manager_GUI_hTreeview, _ISN_Variablen_aufloesen(GUICtrlRead($ISN_UDF_Manager_FileSearch_Input)), 0)
	_WinAPI_SetFocus($ISN_UDF_Manager_GUI_hTreeview)
	$Current_TVExplorer_TreeView = $ISN_UDF_Manager_GUI_hTreeview
EndFunc   ;==>_ISN_UDFManager_AcInputSelectItem

Func _ISN_UDFManager_BackgroundScanForAcInput()
	AdlibUnRegister("_ISN_UDFManager_BackgroundScanForAcInput")

	Local $FinishedArray = $Leeres_Array
	_AcInputUDF_ControlSetAcList($ISN_UDF_Manager_FileSearch_Input, $Leeres_Array)

	;Scan ISN UDFs Folder
	Local $UDFDirFilesArray = _FileListToArrayRec(_ISN_Variablen_aufloesen($UDFs_Folder), "*." & $Autoitextension, $FLTAR_FILES, $FLTAR_RECUR, $FLTAR_NOSORT, $FLTAR_FULLPATH)
	If IsArray($UDFDirFilesArray) And Not @error Then
		_ArrayDelete($UDFDirFilesArray, 0)
		_ArrayConcatenate($FinishedArray, $UDFDirFilesArray)
	EndIf

	;Scan AutoIt Include Folder
	If $Tools_UDFManager_ShowAutoItIncludes = "true" Then
		Local $AutoItUDFDirFilesArray = _FileListToArrayRec(_ISN_Variablen_aufloesen($PathToAutoItIncludes), "*." & $Autoitextension, $FLTAR_FILES, $FLTAR_RECUR, $FLTAR_NOSORT, $FLTAR_FULLPATH)
		If IsArray($AutoItUDFDirFilesArray) And Not @error Then
			_ArrayDelete($AutoItUDFDirFilesArray, 0)
			_ArrayConcatenate($FinishedArray, $AutoItUDFDirFilesArray)
		EndIf
	EndIf

	;Replace paths with ISN Variables
	For $cnt = 0 To UBound($FinishedArray) - 1
		$FinishedArray[$cnt] = _ISN_Pfad_durch_Variablen_ersetzen($FinishedArray[$cnt])
	Next

	;Set array for ACInout
	_AcInputUDF_ControlSetAcList($ISN_UDF_Manager_FileSearch_Input, $FinishedArray)
	_AcInputUDF_ControlSetAcList($quick_view_udfexplorer_searchbar, $FinishedArray)

	;ReRead ISN APIs and Properties
	;_Skripteditor_APIs_und_properties_neu_einlesen()
EndFunc   ;==>_ISN_UDFManager_BackgroundScanForAcInput

Func _ISN_IsPathInAnManagedIncludeDirectory($fullfilepath = "")
	If $fullfilepath = "" Or Not FileExists($fullfilepath) Then Return False

	Local $Pfade_Array = StringSplit(_ISN_Variablen_aufloesen($PathToAutoItIncludes & ";" & $AdditionalIncludePaths_ManagedByISN), ";", 2)
	If IsArray($Pfade_Array) Then
		For $x = 0 To UBound($Pfade_Array) - 1
			If $Pfade_Array[$x] = "" Then ContinueLoop
			If $Pfade_Array[$x] = ";" Then ContinueLoop
			If StringInStr($fullfilepath, $Pfade_Array[$x]) Then Return True
		Next
	EndIf
	Return False
EndFunc   ;==>_ISN_IsPathInAnManagedIncludeDirectory

Func _ISN_FileInManagedIncludeDirectory_TrimIncludeDir($fullfilepath = "")
	If $fullfilepath = "" Or Not FileExists($fullfilepath) Then Return 0

	Local $Pfade_Array = StringSplit(_ISN_Variablen_aufloesen($PathToAutoItIncludes & ";" & $AdditionalIncludePaths_ManagedByISN), ";", 2)
	If IsArray($Pfade_Array) Then
		For $x = 0 To UBound($Pfade_Array) - 1
			If $Pfade_Array[$x] = "" Then ContinueLoop
			If $Pfade_Array[$x] = ";" Then ContinueLoop
			$fullfilepath = StringReplace($fullfilepath, $Pfade_Array[$x], "")
		Next
	EndIf
	If StringLeft($fullfilepath, 1) = "\" Then $fullfilepath = StringTrimLeft($fullfilepath, 1)

	Return $fullfilepath
EndFunc   ;==>_ISN_FileInManagedIncludeDirectory_TrimIncludeDir


Func _ISN_UDF_Manager_IncludeSelectedFileInMainfile()
	Local $Filepath = GUICtrlRead($ISN_UDF_Manager_FilePath_Label)
	If $Filepath = "" Or Not FileExists($Filepath) Then Return
	WinActivate($Studiofenster)
	_Include_IT($Filepath)
	MsgBox(262208, _Get_langstr(61), _Get_langstr(1330), 0, $ISN_UDF_Manager_GUI)
EndFunc   ;==>_ISN_UDF_Manager_IncludeSelectedFileInMainfile

Func _ISN_UDF_Manager_EditSelectedFile()
	Local $Filepath = GUICtrlRead($ISN_UDF_Manager_FilePath_Label)
	If $Filepath = "" Or Not FileExists($Filepath) Then Return
	GUISetState(@SW_HIDE, $ISN_UDF_Manager_GUI)
	WinActivate($Studiofenster)
	Try_to_opten_file($Filepath)
EndFunc   ;==>_ISN_UDF_Manager_EditSelectedFile

Func _ISN_UDF_Manager_GUIResize()
	AdlibUnRegister("_ISN_UDF_Manager_GUIResize")
	Local $ISN_UDF_Manager_GUI_UDFPreview_scintilla_dummypos = _ControlGetPos($ISN_UDF_Manager_GUI, "", $ISN_UDF_Manager_GUI_UDFPreview_scintilla_dummy)
	If IsArray($ISN_UDF_Manager_GUI_UDFPreview_scintilla_dummypos) Then
		WinMove($ISN_UDF_Manager_GUI_UDFPreview_scintilla, "", $ISN_UDF_Manager_GUI_UDFPreview_scintilla_dummypos[0], $ISN_UDF_Manager_GUI_UDFPreview_scintilla_dummypos[1], $ISN_UDF_Manager_GUI_UDFPreview_scintilla_dummypos[2], $ISN_UDF_Manager_GUI_UDFPreview_scintilla_dummypos[3])
	EndIf
EndFunc   ;==>_ISN_UDF_Manager_GUIResize

Func _ISN_UDF_Manager_DestroyTreeView()
	If $ISN_UDF_Manager_GUI_Treeview <> "" Then
		_ISN_Hide_UDF_Manager_NoApiReload()
		_GUICtrlTVExplorer_Destroy($ISN_UDF_Manager_GUI_hTreeview, 1) ;Zerstöre Treeview
		$ISN_UDF_Manager_GUI_hTreeview = ""
		$ISN_UDF_Manager_GUI_Treeview = ""
	EndIf
EndFunc   ;==>_ISN_UDF_Manager_DestroyTreeView

Func _ISN_Hide_UDF_Manager()
	$ISN_UDFManager_WinState = WinGetState($ISN_UDF_Manager_GUI, "")
	If Not BitAND($ISN_UDFManager_WinState, 2) Then Return ;Already hidden
	GUISetState(@SW_HIDE, $ISN_UDF_Manager_GUI)
	$Projektbaum_ist_bereit = 1
	_Skripteditor_APIs_und_properties_neu_einlesen()
EndFunc   ;==>_ISN_Hide_UDF_Manager

Func _ISN_Hide_UDF_Manager_NoApiReload()
	$ISN_UDFManager_WinState = WinGetState($ISN_UDF_Manager_GUI, "")
	If Not BitAND($ISN_UDFManager_WinState, 2) Then Return ;Already hidden
	GUISetState(@SW_HIDE, $ISN_UDF_Manager_GUI)
	_RDC_Delete($RDC_UDFs_Thread)
	$Projektbaum_ist_bereit = 1
EndFunc   ;==>_ISN_Hide_UDF_Manager_NoApiReload

Func _ISN_UDF_Manager_TabSelectEvent()
	Switch _GUICtrlTab_GetCurFocus($ISN_UDF_Manager_Tab)

		Case 0
			ControlShow($ISN_UDF_Manager_GUI, "", $ISN_UDF_Manager_GUI_UDFPreview_scintilla)


		Case 1
			ControlHide($ISN_UDF_Manager_GUI, "", $ISN_UDF_Manager_GUI_UDFPreview_scintilla)

	EndSwitch
EndFunc   ;==>_ISN_UDF_Manager_TabSelectEvent

Func _ISN_UDF_Manager_Inspect_FindAPIFile($fullfilepath = "")

	;Hardcoded AutoIt Includes
	If StringInStr($fullfilepath, _ISN_Variablen_aufloesen($PathToAutoItIncludes)) Then
	    GUICtrlSetState($UDF_Manager_Generator_Button, $GUI_DISABLE)
		Return @ScriptDir & "\Data\Api\au3.api"
	EndIf


	Local $sDrive = "", $sDir = "", $sFileName = "", $sExtension = ""
	_PathSplit($fullfilepath, $sDrive, $sDir, $sFileName, $sExtension)
	Local $FileToFind = "au3." & $sFileName & ".api"


	;Weitere Pfade aus den Programmeinstellungen
	$Orner_Array = StringSplit("%ISNStudioDir%\Data\Api|%MyISNDataDir%\Data\Api|" & $Zusaetzliche_Properties_Ordner, "|", 2)
	If IsArray($Orner_Array) Then
		For $index = 0 To UBound($Orner_Array) - 1
			If $Orner_Array[$index] = "" Then ContinueLoop
			$ResArray = _FileListToArrayRec(_ISN_Variablen_aufloesen($Orner_Array[$index]), "*.*", $FLTAR_FILES, $FLTAR_RECUR, $FLTAR_NOSORT, $FLTAR_FULLPATH)
			If IsArray($ResArray) And Not @error Then
				For $acnt = 0 To UBound($ResArray) - 1
					If $ResArray[$acnt] = "" Or Not FileExists($ResArray[$acnt]) Then ContinueLoop
					_PathSplit($ResArray[$acnt], $sDrive, $sDir, $sFileName, $sExtension)
					If StringLower($sFileName & $sExtension) = StringLower($FileToFind) Then Return $ResArray[$acnt]
				Next
			EndIf
		Next
	EndIf


	;Weitere Projektspezifische Pfade (API)
	If $Offenes_Projekt <> "" Then
		$Projekt_API_Pfade = _ProjectISN_Config_Read("additional_api_folders", "")
		If $Projekt_API_Pfade <> "" Then
			$Orner_Array = StringSplit($Projekt_API_Pfade, "|", 2)
			If IsArray($Orner_Array) Then
				For $index = 0 To UBound($Orner_Array) - 1
					If $Orner_Array[$index] = "" Then ContinueLoop
					$ResArray = _FileListToArrayRec(_ISN_Variablen_aufloesen($Orner_Array[$index]), "*.*", $FLTAR_FILES, $FLTAR_RECUR, $FLTAR_NOSORT, $FLTAR_FULLPATH)
					If IsArray($ResArray) And Not @error Then
						For $acnt = 0 To UBound($ResArray) - 1
							If $ResArray[$acnt] = "" Or Not FileExists($ResArray[$acnt]) Then ContinueLoop
							_PathSplit($ResArray[$acnt], $sDrive, $sDir, $sFileName, $sExtension)
							If StringLower($sFileName & $sExtension) = StringLower($FileToFind) Then Return $ResArray[$acnt]
						Next
					EndIf
				Next
			EndIf
		EndIf
	EndIf

	Return ""
EndFunc   ;==>_ISN_UDF_Manager_Inspect_FindAPIFile

Func _ISN_UDF_Manager_Inspect_FindPropertiesFile($fullfilepath = "")

	;Hardcoded AutoIt Includes
	If StringInStr($fullfilepath, _ISN_Variablen_aufloesen($PathToAutoItIncludes)) Then
	    GUICtrlSetState($UDF_Manager_Generator_Button, $GUI_DISABLE)
		Return @ScriptDir & "\Data\Properties\au3.keywords.properties"
	EndIf


	Local $sDrive = "", $sDir = "", $sFileName = "", $sExtension = ""
	_PathSplit($fullfilepath, $sDrive, $sDir, $sFileName, $sExtension)
	Local $FileToFind = "au3." & $sFileName & ".keywords.properties"

	;Weitere Pfade aus den Programmeinstellungen
	$Orner_Array = StringSplit("%ISNStudioDir%\Data\Properties|%myisndatadir%\Data\Properties|" & $Zusaetzliche_Properties_Ordner, "|", 2)
	If IsArray($Orner_Array) Then
		For $index = 0 To UBound($Orner_Array) - 1
			If $Orner_Array[$index] = "" Then ContinueLoop
			$ResArray = _FileListToArrayRec(_ISN_Variablen_aufloesen($Orner_Array[$index]), "*.*", $FLTAR_FILES, $FLTAR_RECUR, $FLTAR_NOSORT, $FLTAR_FULLPATH)
			If IsArray($ResArray) And Not @error Then
				For $acnt = 0 To UBound($ResArray) - 1
					If $ResArray[$acnt] = "" Or Not FileExists($ResArray[$acnt]) Then ContinueLoop
					_PathSplit($ResArray[$acnt], $sDrive, $sDir, $sFileName, $sExtension)
					If StringLower($sFileName & $sExtension) = StringLower($FileToFind) Then Return $ResArray[$acnt]
				Next
			EndIf
		Next
	EndIf


	;Weitere Projektspezifische Pfade (properties)
	If $Offenes_Projekt <> "" Then
		$Projekt_properties_Pfade = _ProjectISN_Config_Read("additional_properties_folders", "")
		If $Projekt_properties_Pfade <> "" Then
			$Orner_Array = StringSplit($Projekt_properties_Pfade, "|", 2)
			If IsArray($Orner_Array) Then
				For $index = 0 To UBound($Orner_Array) - 1
					If $Orner_Array[$index] = "" Then ContinueLoop
					$ResArray = _FileListToArrayRec(_ISN_Variablen_aufloesen($Orner_Array[$index]), "*.*", $FLTAR_FILES, $FLTAR_RECUR, $FLTAR_NOSORT, $FLTAR_FULLPATH)
					If IsArray($ResArray) And Not @error Then
						For $acnt = 0 To UBound($ResArray) - 1
							If $ResArray[$acnt] = "" Or Not FileExists($ResArray[$acnt]) Then ContinueLoop
							_PathSplit($ResArray[$acnt], $sDrive, $sDir, $sFileName, $sExtension)
							If StringLower($sFileName & $sExtension) = StringLower($FileToFind) Then Return $ResArray[$acnt]
						Next
					EndIf
				Next
			EndIf
		EndIf
	EndIf

	Return ""
EndFunc   ;==>_ISN_UDF_Manager_Inspect_FindPropertiesFile

Func _ISN_UDF_Manager_Inspect_UDF($Path = "")

	Local $sDrive = "", $sDir = "", $sFileName = "", $sExtension = "", $aPathSplit
	Local $IndexFound = 0

	SendMessage($ISN_UDF_Manager_GUI_UDFPreview_scintilla, $SCI_SETREADONLY, False, 0)
	SendMessage($ISN_UDF_Manager_GUI_UDFPreview_scintilla, $SCI_CLEARALL, 0, 0)

	$Path = _ISN_Variablen_aufloesen($Path)
	$aPathSplit = _PathSplit($Path, $sDrive, $sDir, $sFileName, $sExtension)
	If $Path <> "" And FileExists($Path) And ($sExtension = ".txt" Or $sExtension = "." & $Autoitextension) Then

		GUICtrlSetData($ISN_UDF_Manager_FileHeader_Label, $sFileName & $sExtension)
		GUICtrlSetData($ISN_UDF_Manager_FilePath_Label, $Path)
		LoadEditorFile($ISN_UDF_Manager_GUI_UDFPreview_scintilla, $Path)
		SendMessage($ISN_UDF_Manager_GUI_UDFPreview_scintilla, $SCI_SETREADONLY, True, 0)

		If $Studiomodus = "2" Then
			GUICtrlSetState($UDF_Manager_IncludeInMainfile_Button, $GUI_DISABLE)
		Else
			GUICtrlSetState($UDF_Manager_IncludeInMainfile_Button, $GUI_ENABLE)
		EndIf

		GUICtrlSetState($UDF_Manager_OpenFileInEditor_Button, $GUI_ENABLE)
		GUICtrlSetState($UDF_Manager_Generator_Button, $GUI_ENABLE)
		GUICtrlSetData($ISN_UDF_Manager_CallTips_label, _Get_langstr(443))
		GUICtrlSetData($ISN_UDF_Manager_Autocomplete_label, _Get_langstr(443))
		_SetIconAlpha($ISN_UDF_Manager_CallTips_Icon, $smallIconsdll, 210 + 1, 16, 16)
		_SetIconAlpha($ISN_UDF_Manager_Autocomplete_Icon, $smallIconsdll, 210 + 1, 16, 16)

		$FoundAPIFile = _ISN_UDF_Manager_Inspect_FindAPIFile($Path)
		If FileExists($FoundAPIFile) And $FoundAPIFile <> "" Then
			_SetIconAlpha($ISN_UDF_Manager_CallTips_Icon, $smallIconsdll, 314 + 1, 16, 16)
			GUICtrlSetData($ISN_UDF_Manager_CallTips_label, _Get_langstr(1430))
			GUICtrlSetData($ISN_UDF_Manager_CallTipsPath_label, _ISN_Pfad_durch_Variablen_ersetzen($FoundAPIFile))
			GUICtrlSetState($UDF_Manager_OpenAPIFileInISN_Button, $GUI_ENABLE)
			GUICtrlSetState($UDF_Manager_OpenAPIFileInExplorer_Button, $GUI_ENABLE)
		Else
			_SetIconAlpha($ISN_UDF_Manager_CallTips_Icon, $smallIconsdll, 267 + 1, 16, 16)
			GUICtrlSetData($ISN_UDF_Manager_CallTips_label, StringReplace(_Get_langstr(1428), "%1", StringLower("au3." & $sFileName & ".api")))
			GUICtrlSetData($ISN_UDF_Manager_CallTipsPath_label, _Get_langstr(1438))
			GUICtrlSetState($UDF_Manager_OpenAPIFileInISN_Button, $GUI_DISABLE)
			GUICtrlSetState($UDF_Manager_OpenAPIFileInExplorer_Button, $GUI_DISABLE)
		EndIf

		$FoundPropertiesFile = _ISN_UDF_Manager_Inspect_FindPropertiesFile($Path)
		If FileExists($FoundPropertiesFile) And $FoundPropertiesFile <> "" Then
			_SetIconAlpha($ISN_UDF_Manager_Autocomplete_Icon, $smallIconsdll, 314 + 1, 16, 16)
			GUICtrlSetData($ISN_UDF_Manager_Autocomplete_label, _Get_langstr(1431))
			GUICtrlSetData($ISN_UDF_Manager_AutocompletePath_label, _ISN_Pfad_durch_Variablen_ersetzen($FoundPropertiesFile))
			GUICtrlSetState($UDF_Manager_OpenPropertiesFileInISN_Button, $GUI_ENABLE)
			GUICtrlSetState($UDF_Manager_OpenPropertiesFileInExplorer_Button, $GUI_ENABLE)
		Else
			_SetIconAlpha($ISN_UDF_Manager_Autocomplete_Icon, $smallIconsdll, 267 + 1, 16, 16)
			GUICtrlSetData($ISN_UDF_Manager_Autocomplete_label, StringReplace(_Get_langstr(1429), "%1", StringLower("au3." & $sFileName & ".keywords.properties")))
			GUICtrlSetData($ISN_UDF_Manager_AutocompletePath_label, _Get_langstr(1438))
			GUICtrlSetState($UDF_Manager_OpenPropertiesFileInISN_Button, $GUI_DISABLE)
			GUICtrlSetState($UDF_Manager_OpenPropertiesFileInExplorer_Button, $GUI_DISABLE)
		EndIf

	Else
		GUICtrlSetData($ISN_UDF_Manager_FileHeader_Label, _Get_langstr(1417))
		GUICtrlSetData($ISN_UDF_Manager_FilePath_Label, "")
		GUICtrlSetData($ISN_UDF_Manager_CallTips_label, "")
		GUICtrlSetData($ISN_UDF_Manager_Autocomplete_label, "")
		GUICtrlSetData($ISN_UDF_Manager_CallTipsPath_label, "")
		GUICtrlSetData($ISN_UDF_Manager_AutocompletePath_label, "")
		GUICtrlSetState($UDF_Manager_OpenAPIFileInISN_Button, $GUI_DISABLE)
		GUICtrlSetState($UDF_Manager_OpenAPIFileInExplorer_Button, $GUI_DISABLE)
		GUICtrlSetState($UDF_Manager_OpenPropertiesFileInISN_Button, $GUI_DISABLE)
		GUICtrlSetState($UDF_Manager_OpenPropertiesFileInExplorer_Button, $GUI_DISABLE)
		GUICtrlSetState($UDF_Manager_IncludeInMainfile_Button, $GUI_DISABLE)
		GUICtrlSetState($UDF_Manager_OpenFileInEditor_Button, $GUI_DISABLE)
		GUICtrlSetState($UDF_Manager_Generator_Button, $GUI_DISABLE)
		_SetIconAlpha($ISN_UDF_Manager_CallTips_Icon, $smallIconsdll, 210 + 1, 16, 16)
		_SetIconAlpha($ISN_UDF_Manager_Autocomplete_Icon, $smallIconsdll, 210 + 1, 16, 16)
		SendMessage($ISN_UDF_Manager_GUI_UDFPreview_scintilla, $SCI_SETREADONLY, True, 0)

	EndIf

EndFunc   ;==>_ISN_UDF_Manager_Inspect_UDF

Func _ISN_UDF_Manager_OpenAPIFileInISN()
	Local $file = _ISN_Variablen_aufloesen(GUICtrlRead($ISN_UDF_Manager_CallTipsPath_label))
	If $file <> "" And FileExists($file) Then _ISN_OpenFilewithScripteditor($file)
EndFunc   ;==>_ISN_UDF_Manager_OpenAPIFileInISN

Func _ISN_UDF_Manager_OpenPropertiesFileInISN()
	Local $file = _ISN_Variablen_aufloesen(GUICtrlRead($ISN_UDF_Manager_AutocompletePath_label))
	If $file <> "" And FileExists($file) Then _ISN_OpenFilewithScripteditor($file)
EndFunc   ;==>_ISN_UDF_Manager_OpenPropertiesFileInISN

Func _ISN_UDF_Manager_OpenAPIFileInExplorer()
	Local $file = _ISN_Variablen_aufloesen(GUICtrlRead($ISN_UDF_Manager_CallTipsPath_label))
	If $file <> "" And FileExists($file) Then Run("explorer.exe /e,/select, " & FileGetShortName($file))
EndFunc   ;==>_ISN_UDF_Manager_OpenAPIFileInExplorer

Func _ISN_UDF_Manager_OpenPropertiesFileInExplorer()
	Local $file = _ISN_Variablen_aufloesen(GUICtrlRead($ISN_UDF_Manager_AutocompletePath_label))
	If $file <> "" And FileExists($file) Then Run("explorer.exe /e,/select, " & FileGetShortName($file))
EndFunc   ;==>_ISN_UDF_Manager_OpenPropertiesFileInExplorer

Func _ISN_UDF_Manager_ShowApiGenerator()
	Local $sDrive = "", $sDir = "", $sFileName = "", $sExtension = "", $aPathSplit

	Local $Filepath = GUICtrlRead($ISN_UDF_Manager_FilePath_Label)
	$aPathSplit = _PathSplit($Filepath, $sDrive, $sDir, $sFileName, $sExtension)

	GUICtrlSetData($ISN_APIGenerator_InputFile_Input, $Filepath)
	GUICtrlSetData($ISN_APIGenerator_APIOutput_Input, "%MyISNDataDir%\Data\Api\" & StringLower("au3." & $sFileName & ".api"))
	GUICtrlSetData($ISN_APIGenerator_PropertiesOutput_Input, "%MyISNDataDir%\Data\Properties\" & StringLower("au3." & $sFileName & ".keywords.properties"))
	GUICtrlSetData($ISN_APIGenerator_LogEdit, "")
	GUISetState(@SW_SHOW, $ISN_APIGeneratorGUI)
	GUISetState(@SW_DISABLE, $ISN_UDF_Manager_GUI)

EndFunc   ;==>_ISN_UDF_Manager_ShowApiGenerator

Func _ISN_UDF_Manager_HideApiGenerator()
	GUISetState(@SW_ENABLE, $ISN_UDF_Manager_GUI)
	GUISetState(@SW_HIDE, $ISN_APIGeneratorGUI)
EndFunc   ;==>_ISN_UDF_Manager_HideApiGenerator


Func _ISN_UDFManager_RenameFile()

	If $Offenes_Projekt = "" Then Return
	If _GuiCtrlGetFocus($ISN_UDF_Manager_GUI) <> $ISN_UDF_Manager_GUI_Treeview Then Return ;Prüfe ob Projektbaum überhaupt den Fokus besitzt
	If _GUICtrlTreeView_GetSelection($ISN_UDF_Manager_GUI_Treeview) = 0 Then Return
	If _WinAPI_PathIsRoot(_GUICtrlTVExplorer_GetSelected($ISN_UDF_Manager_GUI_hTreeview)) Then Return
	If _ISN_Variablen_aufloesen($UDFs_Folder) = _GUICtrlTVExplorer_GetSelected($ISN_UDF_Manager_GUI_hTreeview) Then
		Return ;cannot rename root
	EndIf

	$file = _GUICtrlTVExplorer_GetSelected($ISN_UDF_Manager_GUI_hTreeview)
	$oldname = StringTrimLeft($file, StringInStr($file, "\", 0, -1))
	If _Schuetze_Wichtige_daten($file) = False Then Return
	If _FileInUse($file) = 1 Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(951), 0, $ISN_UDF_Manager_GUI)
		Return
	EndIf


	$alreadyopen = _GUICtrlTab_FindTab($htab, StringTrimLeft($file, StringInStr($file, "\", 0, -1)))
	If $alreadyopen <> -1 Then
		$res = _ArraySearch($Datei_pfad, $file)
		If $res <> -1 Then
			$alreadyopen = $res
		Else
			$alreadyopen = -1
		EndIf
	EndIf

	If $alreadyopen = -1 Then

		$Projektbaum_ist_bereit = 0 ;Sperre Projektbaum
		$Current_Renamed_TreeView = $ISN_UDF_Manager_GUI_Treeview
		GUICtrlSetStyle($Current_Renamed_TreeView, BitOR(_WinAPI_GetWindowLong(GUICtrlGetHandle($Current_Renamed_TreeView), $GWL_STYLE), $TVS_EDITLABELS)) ;Add $TVS_EDITLABELS for Edit
		$Renamed_TreeViewItem_Text = ""
		_GUICtrlTreeView_EditText($ISN_UDF_Manager_GUI_Treeview, _GUICtrlTreeView_GetSelection($ISN_UDF_Manager_GUI_Treeview))

		HotKeySet("{ENTER}", "_ISN_TreeViewRename_OK")
		HotKeySet("{ESC}", "_ISN_TreeViewRename_Cancel")

	Else
		MsgBox(262144 + 16, _Get_langstr(25), StringTrimLeft($file, StringInStr($file, "\", 0, -1)) & " " & _Get_langstr(78), 0, $ISN_UDF_Manager_GUI)
	EndIf
EndFunc   ;==>_ISN_UDFManager_RenameFile

Func _ISN_UDFManager_APIGenerator_Log($Text = "")
	_GUICtrlEdit_AppendText($ISN_APIGenerator_LogEdit, $Text)
	_GUICtrlEdit_Scroll($ISN_APIGenerator_LogEdit, $SB_SCROLLCARET)
EndFunc   ;==>_ISN_UDFManager_APIGenerator_Log


Func _ISN_UDFManager_APIGenerator_Start()
	Local $Fehler_Beim_Generieren = 0
	Local $Lesemodus = 0
	Local $Lesemodus_letzte_Sektion = ""
	Local $Funktionsnamen = ""
	Local $Description = ""
	Local $Zusatzzeile = ""
	Local $Syntax = ""
	Local $Parameters = ""
	Local $Funktionen_zum_Schreiben = ""
	Local $Calltips_zum_Schreiben = ""
	Local $SourceUDF = _ISN_Variablen_aufloesen(GUICtrlRead($ISN_APIGenerator_InputFile_Input))
	Local $APIFilePath = _ISN_Variablen_aufloesen(GUICtrlRead($ISN_APIGenerator_APIOutput_Input))
	Local $PropertiesFilePath = _ISN_Variablen_aufloesen(GUICtrlRead($ISN_APIGenerator_PropertiesOutput_Input))

	;Reset log
	GUICtrlSetData($ISN_APIGenerator_LogEdit, "")
	_GUICtrlEdit_SetLimitText($ISN_APIGenerator_LogEdit, 999999999999999)

	$Result = MsgBox(262144 + 32 + 4, _Get_langstr(48), _Get_langstr(1441), 0, $ISN_APIGeneratorGUI)
	If $Result <> 6 Or @error Then Return
	_ISN_UDFManager_APIGenerator_Log(_Get_langstr(1439) & "..." & @CRLF & @CRLF)


	If Not FileExists($SourceUDF) Then
		MsgBox(262144 + 16, _Get_langstr(25), StringReplace(_Get_langstr(724), "%1", $SourceUDF), 0, $ISN_APIGeneratorGUI)
		Return
	EndIf


	$Dateiinhalt = FileReadToArray($SourceUDF)
	If IsArray($Dateiinhalt) Then

		For $aktuelle_Zeile_im_Array = 0 To UBound($Dateiinhalt) - 1


			If StringInStr($Dateiinhalt[$aktuelle_Zeile_im_Array], "#FUNCTION#") And $Lesemodus = 1 Then
				$Fehler_Beim_Generieren = 1
				_ISN_UDFManager_APIGenerator_Log(_Get_langstr(25) & ": " & _Get_langstr(1449) & @CRLF)
			EndIf

			If StringInStr($Dateiinhalt[$aktuelle_Zeile_im_Array], "#FUNCTION#") Then $Lesemodus = 1

			If $Lesemodus = 1 Then

				;Funcname
				If StringInStr($Dateiinhalt[$aktuelle_Zeile_im_Array], "; Name") Then
					$Lesemodus_letzte_Sektion = "; Name"
					$Funktionsnamen = $Dateiinhalt[$aktuelle_Zeile_im_Array]
					$Funktionsnamen = StringTrimLeft($Funktionsnamen, StringInStr($Funktionsnamen, "..:", 0, -1) + 2)
					$Funktionsnamen = StringStripWS($Funktionsnamen, 3)
					If $Funktionsnamen = "" Or StringInStr($Funktionsnamen, "(") Or StringInStr($Funktionsnamen, ")") Or StringInStr($Funktionsnamen, "$") Or StringInStr($Funktionsnamen, ",") Then
						$Fehler_Beim_Generieren = 1
						_ISN_UDFManager_APIGenerator_Log(_Get_langstr(25) & ": " & StringReplace(_Get_langstr(1447), "%1", $Dateiinhalt[$aktuelle_Zeile_im_Array]) & @CRLF)
					EndIf
				EndIf

				;Description
				If StringInStr($Dateiinhalt[$aktuelle_Zeile_im_Array], "; Description") Then
					$Lesemodus_letzte_Sektion = "; Description"
					$Description = $Dateiinhalt[$aktuelle_Zeile_im_Array]
					$Description = StringTrimLeft($Description, StringInStr($Description, "..:", 0, -1) + 2)
					$Description = StringStripWS($Description, 3)
				EndIf


				;Syntax
				If StringInStr($Dateiinhalt[$aktuelle_Zeile_im_Array], "; Syntax") Then
					$Lesemodus_letzte_Sektion = "; Syntax"
					$Syntax = $Dateiinhalt[$aktuelle_Zeile_im_Array]
					$Syntax = StringTrimLeft($Syntax, StringInStr($Syntax, "..:", 0, -1) + 2)
					$Syntax = StringStripWS($Syntax, 3)
					If $Syntax = "" Or Not StringInStr($Syntax, "(") Or Not StringInStr($Syntax, ")") Then
						$Fehler_Beim_Generieren = 1
						_ISN_UDFManager_APIGenerator_Log(_Get_langstr(25) & ": " & StringReplace(_Get_langstr(1448), "%1", $Dateiinhalt[$aktuelle_Zeile_im_Array]) & @CRLF)
					EndIf
				EndIf

				;Parameters
				If StringInStr($Dateiinhalt[$aktuelle_Zeile_im_Array], "; Parameters") Then
					$Lesemodus_letzte_Sektion = "; Parameters"
					$Parameters = $Dateiinhalt[$aktuelle_Zeile_im_Array]
					$Parameters = StringTrimLeft($Parameters, StringInStr($Parameters, "..:", 0, -1) + 2)
					$Parameters = StringStripWS($Parameters, 3)
				EndIf


				;Additional rows
				If StringInStr($Dateiinhalt[$aktuelle_Zeile_im_Array], ";") And _ISN_UDFManager_APIGenerator_CheckSection($Dateiinhalt[$aktuelle_Zeile_im_Array]) = "1" Then
					$Zusatzzeile = $Dateiinhalt[$aktuelle_Zeile_im_Array]
					$Zusatzzeile = StringReplace($Zusatzzeile, ";", "")
					$Zusatzzeile = StringStripWS($Zusatzzeile, 3)
					Switch $Lesemodus_letzte_Sektion

						Case "; Description"
							$Description = $Description & " " & $Zusatzzeile

						Case "; Parameters"
							$Parameters = $Parameters & @CRLF & $Zusatzzeile
					EndSwitch

				EndIf

			EndIf


			If (StringInStr($Dateiinhalt[$aktuelle_Zeile_im_Array], "; =======") Or StringInStr($Dateiinhalt[$aktuelle_Zeile_im_Array], ";=======")) And Not StringInStr($Dateiinhalt[$aktuelle_Zeile_im_Array], "#FUNCTION#") Then
				;Schreibe bisher gesammelte werte

				$Lesemodus = 0
				If $Funktionsnamen <> "" Then
					_ISN_UDFManager_APIGenerator_Log(StringReplace(_Get_langstr(1446), "%1", $Funktionsnamen) & @CRLF)
					$Funktionen_zum_Schreiben = $Funktionen_zum_Schreiben & @TAB & $Funktionsnamen & " \" & @CRLF
				EndIf
				If $Syntax <> "" Then
					_ISN_UDFManager_APIGenerator_Log(_Get_langstr(1445) & " " & $Syntax & " " & $Description & @CRLF & @CRLF)
					$Calltips_zum_Schreiben = $Calltips_zum_Schreiben & $Syntax & " " & $Description & @CRLF
				EndIf


				;Reset
				$Lesemodus_letzte_Sektion = ""
				$Funktionsnamen = ""
				$Description = ""
				$Zusatzzeile = ""
				$Syntax = ""
				$Parameters = ""

			EndIf


		Next
	EndIf


	;Check, if a error happend
	If $Fehler_Beim_Generieren = 1 Then
		_ISN_UDFManager_APIGenerator_Log(_Get_langstr(1443) & @CRLF)
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1443), 0, $ISN_APIGeneratorGUI)
		Return
	EndIf

	;Write .api file
	If $PropertiesFilePath <> "" AND $Funktionen_zum_Schreiben <> "" Then
		_ISN_UDFManager_APIGenerator_Log(@CRLF)
		_ISN_UDFManager_APIGenerator_Log(StringReplace(_Get_langstr(1444), "%1", $PropertiesFilePath))
		Local $hFileOpen = FileOpen($PropertiesFilePath, $FO_OVERWRITE)
		FileWrite($hFileOpen, "au3.keywords.udfs= \" & @CRLF)
		If $hFileOpen = -1 Or FileWrite($hFileOpen, StringLower($Funktionen_zum_Schreiben)) = 0 Then
			MsgBox(262144 + 16, _Get_langstr(25), StringReplace(_Get_langstr(1442), "%1", $PropertiesFilePath), 0, $ISN_APIGeneratorGUI)
			Return
		EndIf
		FileClose($hFileOpen)
		_ISN_UDFManager_APIGenerator_Log(_Get_langstr(7) & @CRLF)
	EndIf

	;Write .properties file
	If $APIFilePath <> "" AND $Calltips_zum_Schreiben <> "" Then
		_ISN_UDFManager_APIGenerator_Log(StringReplace(_Get_langstr(1444), "%1", $APIFilePath))
		Local $hFileOpen = FileOpen($APIFilePath, $FO_OVERWRITE)
		If $hFileOpen = -1 Or FileWrite($hFileOpen, $Calltips_zum_Schreiben) = 0 Then
			MsgBox(262144 + 16, _Get_langstr(25), StringReplace(_Get_langstr(1442), "%1", $APIFilePath), 0, $ISN_APIGeneratorGUI)
			Return
		EndIf
		FileClose($hFileOpen)
		_ISN_UDFManager_APIGenerator_Log(_Get_langstr(7) & @CRLF & @CRLF)
	EndIf

	;Finish
	_ISN_UDFManager_APIGenerator_Log(_Get_langstr(249) & @CRLF)
	MsgBox(262208, _Get_langstr(61), _Get_langstr(1330), 0, $ISN_APIGeneratorGUI)
	_Skripteditor_APIs_und_properties_neu_einlesen()
	_ISN_UDF_Manager_Inspect_UDF(GUICtrlRead($ISN_UDF_Manager_FilePath_Label))

EndFunc   ;==>_ISN_UDFManager_APIGenerator_Start

Func _ISN_UDFManager_APIGenerator_CheckSection($str = "")
	If StringInStr($str, "; Name") Then Return "0"
	If StringInStr($str, "; Description") Then Return "0"
	If StringInStr($str, "; Syntax") Then Return "0"
	If StringInStr($str, "; Parameters") Then Return "0"
	If StringInStr($str, "; Return values") Then Return "0"
	If StringInStr($str, "; Author") Then Return "0"
	If StringInStr($str, "; Modified") Then Return "0"
	If StringInStr($str, "; Remarks") Then Return "0"
	If StringInStr($str, "; Related") Then Return "0"
	If StringInStr($str, "; Link") Then Return "0"
	If StringInStr($str, "; Example") Then Return "0"
	If StringInStr($str, "; AutoIt Version") Then Return "0"
	If StringInStr($str, "; Beschreibung") Then Return "0"
	If StringInStr($str, "; ===") Then Return "0"
	If StringInStr($str, "#FUNCTION#") Then Return "0"
	Return "1"
EndFunc   ;==>_ISN_UDFManager_APIGenerator_CheckSection

Func _ISN_QuickView_UDFExplorer_ClearSearchbar()
	GUICtrlSetData($quick_view_udfexplorer_searchbar, "")
	_WinAPI_SetFocus(GUICtrlGetHandle($quick_view_udfexplorer_searchbar))
EndFunc   ;==>_ISN_QuickView_UDFExplorer_ClearSearchbar

Func _ISN_QuickView_UDFExplorer_AcInputSelectItem()
	_AcInputUDF_AutocompleteSelectedItem()
	_GUICtrlTVExplorer_Expand($quick_view_udfexplorer_htreeview, _ISN_Variablen_aufloesen(GUICtrlRead($quick_view_udfexplorer_searchbar)), 0)
   _WinAPI_SetFocus($quick_view_udfexplorer_htreeview)
   $Current_TVExplorer_TreeView = $quick_view_udfexplorer_htreeview
EndFunc   ;==>_ISN_QuickView_UDFExplorer_AcInputSelectItem




